import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create figure and axis
fig, ax = plt.subplots(figsize=(6, 9))

# Define colors
colors = {
    "rightl0": "blue",
    "rightl1": "green",
    "square0": "red",
    "square1": "yellow",
    "clear": "lightgray"
}

# Define grid size
rows, cols = 6, 4
cell_size = 1

# Draw grid
for row in range(rows):
    for col in range(cols):
        ax.add_patch(patches.Rectangle((col, row), cell_size, cell_size, fill=True, color=colors["clear"], edgecolor='gray'))

# Draw pieces
# rightl0 (blue)
ax.add_patch(patches.Rectangle((0, 3), cell_size, 2*cell_size, fill=True, color=colors["rightl0"], edgecolor='black', linewidth=2))
ax.add_patch(patches.Rectangle((1, 3), cell_size, cell_size, fill=True, color=colors["rightl0"], edgecolor='black', linewidth=2))
ax.text(0.5, 3.5, 'rightl0', color='white', ha='center', va='center', fontsize=8)
ax.text(0.5, 4.5, 'rightl0', color='white', ha='center', va='center', fontsize=8)
ax.text(1.5, 3.5, 'rightl0', color='white', ha='center', va='center', fontsize=8)

# rightl1 (green)
ax.add_patch(patches.Rectangle((0, 0), cell_size, 2*cell_size, fill=True, color=colors["rightl1"], edgecolor='black', linewidth=2))
ax.add_patch(patches.Rectangle((1, 1), cell_size, cell_size, fill=True, color=colors["rightl1"], edgecolor='black', linewidth=2))
ax.text(0.5, 0.5, 'rightl1', color='white', ha='center', va='center', fontsize=8)
ax.text(0.5, 1.5, 'rightl1', color='white', ha='center', va='center', fontsize=8)
ax.text(1.5, 1.5, 'rightl1', color='white', ha='center', va='center', fontsize=8)

# square0 (red)
ax.add_patch(patches.Rectangle((2, 1), cell_size, cell_size, fill=True, color=colors["square0"], edgecolor='black', linewidth=2))
ax.text(2.5, 1.5, 'square0', color='white', ha='center', va='center', fontsize=8)

# square1 (yellow)
ax.add_patch(patches.Rectangle((2, 2), cell_size, cell_size, fill=True, color=colors["square1"], edgecolor='black', linewidth=2))
ax.text(2.5, 2.5, 'square1', color='black', ha='center', va='center', fontsize=8)

# Set limits and grid
ax.set_xlim(0, cols)
ax.set_ylim(0, rows)
ax.set_xticks([])
ax.set_yticks([])
ax.set_aspect('equal')

# Legend
legend_elements = [
    patches.Patch(facecolor=colors["rightl0"], edgecolor='black', label='rightl0 (occupied)'),
    patches.Patch(facecolor=colors["rightl1"], edgecolor='black', label='rightl1 (occupied)'),
    patches.Patch(facecolor=colors["square0"], edgecolor='black', label='square0 (occupied)'),
    patches.Patch(facecolor=colors["square1"], edgecolor='black', label='square1 (occupied)'),
    patches.Patch(facecolor=colors["clear"], edgecolor='gray', label='clear')
]
ax.legend(handles=legend_elements, loc='upper right', fontsize=8)

# Save the figure
plt.savefig('tetris/one_shot/ini_diagram_code/attempts/attempt_21.png', bbox_inches='tight')
plt.show()